//////////////////////////////////////////////////////////////////
//
// Project.cpp - cpp file
//
// This file was generated using the RTX64 Application Template for Visual Studio.
//
// Created: 7/28/2021 4:33:02 PM 
// User: Lincoln
//
//////////////////////////////////////////////////////////////////

#include "Project.h"
#include "PMC_RTX64_Cpp_API.h"   
#include "PMC_RTX64_Examples.h"

using namespace PMC;

int _tmain(int argc, _TCHAR * argv[])
{
	RtPrintf("\nTest starting\n");

	KsError Code = KsError::errNoError;
	KsCommandStatus Command = { 0 };

	// Always call Create first. It will start the KINGSTAR subsystem if necessary and connect with it.
	// Use instance 0 unless you purchased a multi-runtime license.
	// Use Ideal Processor 0 for the default RTX64 processor.
	Code = Create(0, 0);
	if (Code != errNoError) {
		RtPrintf("Failed to create: 0x%x\n", Code);
		return Code;
	}

	//check etherCAT status 
	SubsystemStatus etherCAT_status;
	SubsystemDiagnostics etherCAT_Diag;
	Code = GetStatus(&etherCAT_status, &etherCAT_Diag);
	//if etherCAT isn't currently running
	if (Code != errNoError || etherCAT_status.State != EthercatState::ecatOP)
	{
		// EtherCAT cycle time set to 1 millisecond
		Code = SetCycleTime(cycle1000);
		if (Code != errNoError) {
			RtPrintf("Failed to set cycle time: 0x%x\n", Code);
			return Code;
		}

		// Disable logs in the RTX64 server console.
		Code = EnableServerLog(FALSE);
		if (Code != errNoError) {
			RtPrintf("Failed to set server log: 0x%x\n", Code);
			return Code;
		}
		// Disable Hot Connect.
		Code = EnableHotConnect(FALSE);
		RtPrintf("Subsystem configured\n");

		// Start the EtherCAT network
		// The timeout is set to 30s and the start command will be aborted if it is not done by then.
		Command = WaitForCommand(30, TRUE, Start());
		if (!Command.Done) {
			RtPrintf("Failed to start EtherCAT: 0x%x\n", Command.ErrorId);
			return Code;
		}
		RtPrintf("Subsystem Started\n");
	}
	else
	{
		RtPrintf("Subsystem already started\n");
	}

	FindPMCsRtn FoundPMCs = PMC_API::FindPMCs();

	PMC_API PMC01;
	PMCRTN rtn = PMC01.ConnectToPMC(FoundPMCs.PMCIOIndexes[0],1000);

	if (rtn != PMCRTN::ALLOK)
	{
		RtPrintf("PMC connection failed\n");
		return (int)rtn;
	}

	PMC01.ActivateXbots(0);
	PollForPMCState(&PMC01);

	Example01_longaxismotion(&PMC01);
	//Example02_shortaxismotion(&PMC01);
	//Example03_groups(&PMC01);
	//Example04_waituntil(&PMC01);
	//Example05_pmccontrol(&PMC01);
	//Example06_sync(&PMC01);
	//Example07_sun(&PMC01);
	//Example08_bufferstatus(&PMC01);
	//Example09_groupstatus(&PMC01);
	//Example10_waituntiltime(&PMC01);
	//Example11_readxbotposition(&PMC01);
	//Example12_DImacro(&PMC01);
	//Example13_waituntilDI(&PMC01);
	//Example14_DOcmdlb(&PMC01);
	//Example15_DOdisplacement(&PMC01);
	//Example16_DOmotion(&PMC01);
	//Example17_cam(&PMC01);
	//Example18_jogging(&PMC01);
	//Example19_force(&PMC01);
	//Example20_DOforce(&PMC01);
	//Example21_startupPMS(&PMC01);
	//Example22_streaming(&PMC01);
	//Example23_autodrivingvelocity(&PMC01);
	//Example24a_autoloading_sending(&PMC01);
	//Example24b_autoloading_receiving(&PMC01);
	//Example25_stereotypes(&PMC01);
	//Example26_serialnumbers(&PMC01);
	//Example27_levitatelandspeed(&PMC01);
	//Example28a_zoneunloading(&PMC01);
	//Example28b_zoneloading(&PMC01);
	//Example29_recoveryaccident(&PMC01);
	//Example30_incoming(&PMC01);
	//Example31_extendedfeedback(&PMC01);
	//Example32_zonefencing(&PMC01);
	//Example33_StarWheel(&PMC01);
	//Example34_RotaryMotion(&PMC01);
	//Example35_Sectors(&PMC01);
	//Example36_SetDateAndTime(&PMC01);
	//Example37_ApplicationDesigner(&PMC01);

	PMC01.DisconnectFromPMC();

	RtPrintf("Test ended\n");

    return 0;
}
